#ifndef DIAMOND_DUAL_MESH_BUILDER_HPP
#define DIAMOND_DUAL_MESH_BUILDER_HPP

#include <mesh/IMesh.hpp>
#include <mesh/MeshBuilderBase.hpp>

#include <memory>

template <size_t>
class Connectivity;

class ConnectivityDescriptor;

class DiamondDualMeshBuilder : public MeshBuilderBase
{
 private:
  template <size_t Dimension>
  void _buildDiamondConnectivityDescriptor(const Connectivity<Dimension>&, ConnectivityDescriptor&);

  template <size_t Dimension>
  void _buildDiamondMeshFrom(const std::shared_ptr<const IMesh>&);

 public:
  DiamondDualMeshBuilder(const std::shared_ptr<const IMesh>&);
  ~DiamondDualMeshBuilder() = default;
};

#endif   // DIAMOND_DUAL_MESH_BUILDER_HPP
