#ifndef PUGS_UTILS_HPP
#define PUGS_UTILS_HPP

#include <Kokkos_Core.hpp>
#include <utils/PugsMacros.hpp>

#include <functional>
#include <string>

template <typename FunctionType>
PUGS_FORCEINLINE void
parallel_for(size_t size, const FunctionType& lambda, const std::string& label = "")
{
  Kokkos::parallel_for(size, lambda, label);
}

template <typename ArrayType, typename ReturnType>
PUGS_FORCEINLINE void
parallel_reduce(size_t size, const ArrayType& array, ReturnType& value, const std::string& label = "")
{
  Kokkos::parallel_reduce(label, size, array, value);
}

std::string pugsBuildInfo();

std::string pugsVersion();

std::string initialize(int& argc, char* argv[]);

void finalize();

#endif   // PUGS_UTILS_HPP
