#ifndef TYPE_OF_ITEM_HPP
#define TYPE_OF_ITEM_HPP

#include <utility>

enum class TypeOfItem {
  node = 0,
  edge = 1,
  face = 2,
  cell = 3
};

template <size_t Dimension>
struct ItemId {};

template <>
struct ItemId<1>
{
  inline static constexpr size_t itemId(const TypeOfItem& item_type) {
    switch(item_type) {
      case TypeOfItem::cell: {
        return 0;
      }
      case TypeOfItem::face:
      case TypeOfItem::edge:
      case TypeOfItem::node: {
        // in 1d, faces, edges and nodes are the same
        return 1;
      }
    }
  }
};

template <>
struct ItemId<2>
{
  inline static constexpr size_t itemId(const TypeOfItem& item_type) {
    switch(item_type) {
      case TypeOfItem::cell: {
        return 0;
      }
      case TypeOfItem::face:
      case TypeOfItem::edge: {
        // in 2d, faces and edges are the same
        return 1;
      }
      case TypeOfItem::node: {
        return 2;
      }
    }
  }
};

template <>
struct ItemId<3>
{
  inline static constexpr size_t itemId(const TypeOfItem& item_type) {
    switch(item_type) {
      case TypeOfItem::cell: {
        return 0;
      }
      case TypeOfItem::face: {
        return 1;
      }
      case TypeOfItem::edge: {
        // in 2d, faces and edges are the same
        return 2;
      }
      case TypeOfItem::node: {
        return 3;
      }
    }
  }
};

#endif // TYPE_OF_ITEM_HPP
