#ifndef ICONNECTIVITY_HPP
#define ICONNECTIVITY_HPP

#include <TypeOfItem.hpp>
#include <ConnectivityMatrix.hpp>

struct IConnectivity
{
  virtual const ConnectivityMatrix&
  itemToItemMatrix(const TypeOfItem& item_type_0,
                   const TypeOfItem& item_type_1) const = 0;

  IConnectivity() = default;
  IConnectivity(const IConnectivity&) = delete;
  virtual ~IConnectivity() = default;
};

#endif // ICONNECTIVITY_HPP
