#ifndef CONNECTIVITY_MATRIX_HPP
#define CONNECTIVITY_MATRIX_HPP

#include <Kokkos_Core.hpp>
#include <Kokkos_StaticCrsGraph.hpp>

class ConnectivityMatrix
{
 private:
  typedef Kokkos::StaticCrsGraph<unsigned int, Kokkos::HostSpace> HostMatrix;
  HostMatrix m_host_matrix;

 public:
  typedef HostMatrix::row_map_type HostRowType;

  const auto& entries() const
  {
    return m_host_matrix.entries;
  }

  const auto& rowsMap() const
  {
    return m_host_matrix.row_map;
  }

  KOKKOS_INLINE_FUNCTION
  const auto numEntries() const
  {
    return m_host_matrix.entries.extent(0);
  }

  KOKKOS_INLINE_FUNCTION
  const auto numRows() const
  {
    return m_host_matrix.numRows();
  }

  KOKKOS_INLINE_FUNCTION
  const auto rowConst(const size_t& j) const
  {
    return m_host_matrix.rowConst(j);
  }

  KOKKOS_INLINE_FUNCTION
  const auto rowMap(const size_t& j) const
  {
    return m_host_matrix.row_map[j];
  }

  KOKKOS_INLINE_FUNCTION
  ConnectivityMatrix(const std::vector<std::vector<unsigned int>>& initializer)
      : m_host_matrix(Kokkos::create_staticcrsgraph<HostMatrix>("connecticity_matrix", initializer))
  {
    ;
  }

  KOKKOS_INLINE_FUNCTION
  ConnectivityMatrix(const ConnectivityMatrix& connecticity_matrix,std::vector<std::vector<unsigned int>>& initializer)
      : m_host_matrix(Kokkos::create_staticcrsgraph<HostMatrix>("connecticity_matrix", initializer))
  {
    ;
  }

  [[deprecated("Must only define connectivities so that only unsigned int should be treated")]]
  ConnectivityMatrix(const std::vector<std::vector<unsigned short>>& initializer)
  : m_host_matrix(Kokkos::create_staticcrsgraph<HostMatrix>("connecticity_matrix", initializer))
  {
    ;
  }

  ConnectivityMatrix& operator=(const ConnectivityMatrix&) = default;
  ConnectivityMatrix& operator=(ConnectivityMatrix&&) = default;

  ConnectivityMatrix() = default;
  ConnectivityMatrix(const ConnectivityMatrix&) = default;
  ConnectivityMatrix(ConnectivityMatrix&&) = default;
  ~ConnectivityMatrix() = default;
};

#endif // CONNECTIVITY_MATRIX_HPP
