#ifndef CONNECTIVITY_COMPUTER_HPP
#define CONNECTIVITY_COMPUTER_HPP

#include <ConnectivityMatrix.hpp>
#include <SubItemValuePerItem.hpp>

struct ConnectivityComputer
{
  void computeInverseConnectivityMatrix(const ConnectivityMatrix& item_to_child_item_matrix,
                                        ConnectivityMatrix& child_item_to_item_matrix) const;

  void computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                         const ConnectivityMatrix& child_item_to_items_matrix,
                                         CellValuePerNode<unsigned short>&  child_item_number_in_item_matrix) const;

  void computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                         const ConnectivityMatrix& child_item_to_items_matrix,
                                         NodeValuePerCell<unsigned short>&  child_item_number_in_item_matrix) const;

  void computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                         const ConnectivityMatrix& child_item_to_items_matrix,
                                         CellValuePerFace<unsigned short>&  child_item_number_in_item_matrix) const;
};

#endif // CONNECTIVITY_COMPUTER_HPP
