#ifndef AST_NODE_DATATYPE_HPP
#define AST_NODE_DATATYPE_HPP

#include <string>
#include <variant>

namespace language
{
enum class DataType
{
  undefined_t    = -1,
  bool_t         = 0,
  unsigned_int_t = 1,
  int_t          = 2,
  string_t       = 5,
  double_t       = 3,
  typename_t     = 10,
  void_t         = 9999
};

std::string dataTypeName(const DataType& data_type);

DataType dataTypePromotion(const DataType& data_type_1, const DataType& data_type_2);

using DataVariant = std::variant<std::monostate, bool, uint64_t, int64_t, double, std::string>;

}   // namespace language

#endif   // AST_NODE_DATATYPE_HPP
