#include <ConsoleManager.hpp>
#include <rang.hpp>

bool ConsoleManager::isTerminal(std::ostream& os)
{
  return rang::rang_implementation::isTerminal(os.rdbuf());
}

void ConsoleManager::init(const std::string& colorize)
{
  std::cout << "Console management: color ";
  if (colorize == "auto") {
    if (isTerminal(std::cout)) {
      std::cout << rang::style::bold
		<< rang::fgB::green
		<< "enabled"
		<< rang::fg::reset
		<< rang::style::reset;
    } else {
      std::cout << "disabled";
    }
    std::cout << " [auto]\n";
  } else if (colorize == "yes") {
    rang::setControlMode(rang::control::Force);
    std::cout << rang::style::bold
	      << rang::fgB::green
	      << "enabled"
	      << rang::fg::reset
	      << rang::style::reset;
    std::cout << " ["
	      << rang::style::bold
	      << rang::fgB::red
	      << "forced"
	      << rang::fg::reset
	      << rang::style::reset
	      << "]\n";
  } else if (colorize == "no") {
    rang::setControlMode(rang::control::Off);
    std::cout << "disabled [forced]\n";
  } else {
    std::cerr << "Unknown colorize option: " << colorize << '\n';
    std::exit(1);
  }
}
