#include <mesh/MeshLineFaceBoundary.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshLineNodeBoundary.hpp>
#include <utils/Messenger.hpp>

template <size_t Dimension>
MeshLineFaceBoundary<Dimension>
getMeshLineFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh, const IBoundaryDescriptor& boundary_descriptor)
{
  MeshFaceBoundary<Dimension> mesh_face_boundary          = getMeshFaceBoundary(mesh, boundary_descriptor);
  MeshLineNodeBoundary<Dimension> mesh_line_node_boundary = getMeshLineNodeBoundary(mesh, boundary_descriptor);

  return MeshLineFaceBoundary<Dimension>{mesh, mesh_face_boundary.refFaceList(), mesh_line_node_boundary.direction()};
}

template MeshLineFaceBoundary<2> getMeshLineFaceBoundary(const Mesh<Connectivity<2>>&, const IBoundaryDescriptor&);
