#ifndef ITEM_OF_ITEM_TYPE_HPP
#define ITEM_OF_ITEM_TYPE_HPP

#include <ItemType.hpp>

template <ItemType sub_item_t, ItemType item_t>
struct ItemOfItemType
{
  static_assert(sub_item_t != item_t, "item and its sub-item cannot be of same type");

  constexpr static ItemType sub_item_type = sub_item_t;
  constexpr static ItemType item_type     = item_t;

  using Reversed = ItemOfItemType<item_type, sub_item_type>;
};

using FaceOfCell = ItemOfItemType<ItemType::face, ItemType::cell>;
using EdgeOfCell = ItemOfItemType<ItemType::edge, ItemType::cell>;
using NodeOfCell = ItemOfItemType<ItemType::node, ItemType::cell>;

using CellOfFace = ItemOfItemType<ItemType::cell, ItemType::face>;
using EdgeOfFace = ItemOfItemType<ItemType::edge, ItemType::face>;
using NodeOfFace = ItemOfItemType<ItemType::node, ItemType::face>;

using CellOfEdge = ItemOfItemType<ItemType::cell, ItemType::edge>;
using FaceOfEdge = ItemOfItemType<ItemType::face, ItemType::edge>;
using NodeOfEdge = ItemOfItemType<ItemType::node, ItemType::edge>;

using CellOfNode = ItemOfItemType<ItemType::cell, ItemType::node>;
using FaceOfNode = ItemOfItemType<ItemType::face, ItemType::node>;
using EdgeOfNode = ItemOfItemType<ItemType::edge, ItemType::node>;

#endif   // ITEM_OF_ITEM_TYPE_HPP
