#ifndef CONNECTIVITY_MATRIX_HPP
#define CONNECTIVITY_MATRIX_HPP

#include <Array.hpp>
#include <Kokkos_StaticCrsGraph.hpp>
#include <PugsUtils.hpp>

class ConnectivityMatrix
{
 private:
  using HostMatrix = Kokkos::StaticCrsGraph<unsigned int, Kokkos::HostSpace>;
  HostMatrix m_host_matrix;

  bool m_is_built{false};

 public:
  using HostRowType = HostMatrix::row_map_type;

  const bool&
  isBuilt() const
  {
    return m_is_built;
  }

  auto
  entries() const
  {
    return encapsulate(m_host_matrix.entries);
    // using DataType = typename decltype(m_host_matrix.entries)::value_type;
    // return Array<DataType>(m_host_matrix.entries);
  }

  const auto&
  rowsMap() const
  {
    return m_host_matrix.row_map;
  }

  PUGS_INLINE
  auto
  numEntries() const
  {
    return m_host_matrix.entries.extent(0);
  }

  PUGS_INLINE
  auto
  numRows() const
  {
    return m_host_matrix.numRows();
  }

  PUGS_INLINE
  auto
  rowConst(const size_t& j) const
  {
    return m_host_matrix.rowConst(j);
  }

  PUGS_INLINE
  const auto&
  rowMap(const size_t& j) const
  {
    return m_host_matrix.row_map[j];
  }

  PUGS_INLINE
  ConnectivityMatrix(const std::vector<std::vector<unsigned int>>& initializer)
    : m_host_matrix{Kokkos::create_staticcrsgraph<HostMatrix>("connectivity_matrix", initializer)}, m_is_built{true}
  {
    ;
  }

  ConnectivityMatrix& operator=(const ConnectivityMatrix&) = default;
  ConnectivityMatrix& operator=(ConnectivityMatrix&&) = default;

  ConnectivityMatrix()                          = default;
  ConnectivityMatrix(const ConnectivityMatrix&) = default;
  ConnectivityMatrix(ConnectivityMatrix&&)      = default;
  ~ConnectivityMatrix()                         = default;
};

#endif   // CONNECTIVITY_MATRIX_HPP
