#ifndef CONNECTIVITY_COMPUTER_HPP
#define CONNECTIVITY_COMPUTER_HPP

#include <ConnectivityMatrix.hpp>
#include <SubItemValuePerItem.hpp>

class ConnectivityComputer
{
 private:
  ConnectivityMatrix _computeInverse(const ConnectivityMatrix& item_to_child_matrix) const;

 public:
  template <typename ConnectivityType>
  ConnectivityMatrix computeConnectivityMatrix(const ConnectivityType& connectivity,
                                               const ItemType& item_type,
                                               const ItemType& child_item_type) const;

  template <typename ItemOfItem, typename ConnectivityType>
  WeakSubItemValuePerItem<const unsigned short, typename ItemOfItem::Reversed> computeLocalItemNumberInChildItem(
    const ConnectivityType& connectivity) const;

  ConnectivityComputer(const ConnectivityComputer&) = default;
  ConnectivityComputer()                            = default;
  ~ConnectivityComputer()                           = default;
};

#endif   // CONNECTIVITY_COMPUTER_HPP
