#include <ASTNodeDataType.hpp>

namespace language
{
std::string
dataTypeName(const DataType& data_type)
{
  std::string name;
  switch (data_type) {
  case DataType::undefined_t:
    name = "undefined";
    break;
  case DataType::bool_t:
    name = "B";
    break;
  case DataType::unsigned_int_t:
    name = "N";
    break;
  case DataType::int_t:
    name = "Z";
    break;
  case DataType::double_t:
    name = "R";
    break;
  case DataType::string_t:
    name = "string";
    break;
  case DataType::typename_t:
    name = "typename";
    break;
  case DataType::void_t:
    name = "void";
    break;
  }
  return name;
}

DataType
dataTypePromotion(const DataType& data_type_1, const DataType& data_type_2)
{
  if (data_type_1 == data_type_2) {
    return data_type_1;
  } else if ((std::max(data_type_1, data_type_2) <= DataType::double_t) and
             (std::min(data_type_1, data_type_2) >= DataType::bool_t)) {
    return std::max(data_type_1, data_type_2);
  } else {
    return DataType::undefined_t;
  }
}

}   // namespace language
