#ifndef FINITE_VOLUMES_EULER_UNKNOWNS_HPP
#define FINITE_VOLUMES_EULER_UNKNOWNS_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/ItemValue.hpp>
#include <scheme/BlockPerfectGas.hpp>

template <typename MeshType>
class FiniteVolumesEulerUnknowns
{
 public:
  static constexpr size_t Dimension = MeshType::Dimension;

  using Rd = TinyVector<Dimension>;

 private:
  CellValue<double> m_rhoj;
  CellValue<Rd> m_uj;
  CellValue<double> m_Ej;

  CellValue<double> m_ej;
  CellValue<double> m_pj;
  CellValue<double> m_gammaj;
  CellValue<double> m_cj;
  CellValue<double> m_mj;
  CellValue<double> m_inv_mj;

 public:
  CellValue<double>&
  rhoj()
  {
    return m_rhoj;
  }

  const CellValue<const double>
  rhoj() const
  {
    return m_rhoj;
  }

  CellValue<Rd>&
  uj()
  {
    return m_uj;
  }

  const CellValue<const Rd>
  uj() const
  {
    return m_uj;
  }

  CellValue<double>&
  Ej()
  {
    return m_Ej;
  }

  const CellValue<const double>
  Ej() const
  {
    return m_Ej;
  }

  CellValue<double>&
  ej()
  {
    return m_ej;
  }

  const CellValue<const double>
  ej() const
  {
    return m_ej;
  }

  CellValue<double>&
  pj()
  {
    return m_pj;
  }

  const CellValue<const double>
  pj() const
  {
    return m_pj;
  }

  CellValue<double>&
  gammaj()
  {
    return m_gammaj;
  }

  const CellValue<const double>
  gammaj() const
  {
    return m_gammaj;
  }

  CellValue<double>&
  cj()
  {
    return m_cj;
  }

  const CellValue<const double>
  cj() const
  {
    return m_cj;
  }

  CellValue<double>&
  mj()
  {
    return m_mj;
  }

  const CellValue<const double>
  mj() const
  {
    return m_mj;
  }

  CellValue<double>&
  invMj()
  {
    return m_inv_mj;
  }

  const CellValue<const double>
  invMj() const
  {
    return m_inv_mj;
  }

  FiniteVolumesEulerUnknowns(const MeshType& mesh)
    : m_rhoj(mesh.connectivity()),
      m_uj(mesh.connectivity()),
      m_Ej(mesh.connectivity()),
      m_ej(mesh.connectivity()),
      m_pj(mesh.connectivity()),
      m_gammaj(mesh.connectivity()),
      m_cj(mesh.connectivity()),
      m_mj(mesh.connectivity()),
      m_inv_mj(mesh.connectivity())
  {
    ;
  }
};

#endif   // FINITE_VOLUMES_EULER_UNKNOWNS_HPP
