#ifndef DISCONTINUOUS_GALERKIN_1D_TOOLS
#define DISCONTINUOUS_GALERKIN_1D_TOOLS

#include <rang.hpp>

#include <utils/ArrayUtils.hpp>

#include <utils/PugsAssert.hpp>

#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/MeshNodeBoundary.hpp>

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>

#include <analysis/Polynomial.hpp>
#include <analysis/PolynomialBasis.hpp>

#include <mesh/ItemValueUtils.hpp>
#include <mesh/SubItemValuePerItem.hpp>

#include <utils/Exceptions.hpp>
#include <utils/Messenger.hpp>

#include <iostream>

template <size_t Degree>
class DiscontinuousGalerkin1DTools
{
  constexpr static size_t Dimension = 1;

  using Rd  = TinyVector<Degree>;
  using Rdd = TinyMatrix<Degree>;

  using R1 = TinyVector<Dimension>;

 public:
  int
  inverse() const
  {
    return 0;
  }

  void
  elementarySolve(Polynomial<Degree>& U,
                  const TinyVector<Degree + 1> moments,
                  const PolynomialBasis<Degree> Basis,
                  const double& xinf,
                  const double& xsup) const
  {
    TinyMatrix<Degree + 1> M(zero);
    for (size_t i = 0; i <= Degree; ++i) {
      for (size_t j = 0; j <= Degree; ++j) {
        Polynomial<2 * Degree> P = Basis.elements()[i] * Basis.elements()[j];
        M(i, j)                  = integrate(P, xinf, xsup);
      }
    }
    TinyMatrix inv_M = ::inverse(M);
    U.coefficients() = inv_M * moments;
  }

  // void
  // integrate() const
  // {}

 public:
  // TODO add a flux manager to constructor
  // TODO add a basis to constructor
  DiscontinuousGalerkin1DTools()
  {
    ;
  }
};

#endif   // DISCONTINUOUS_GALERKIN_1D_TOOLS
