#ifndef INTERPOLATE_ARRAY_HPP
#define INTERPOLATE_ARRAY_HPP

#include <language/utils/PugsFunctionAdapter.hpp>

template <typename T>
class InterpolateArray;
template <typename OutputType, typename InputType>
class InterpolateArray<OutputType(InputType)> : public PugsFunctionAdapter<OutputType(InputType)>
{
  static constexpr size_t Dimension = OutputType::Dimension;
  using Adapter                     = PugsFunctionAdapter<OutputType(InputType)>;

 public:
  static inline Array<OutputType>
  interpolate(const FunctionSymbolId& function_symbol_id, const Array<const InputType>& position)
  {
    auto& expression    = Adapter::getFunctionExpression(function_symbol_id);
    auto convert_result = Adapter::getResultConverter(expression.m_data_type);

    Array<ExecutionPolicy> context_list = Adapter::getContextList(expression);

    using execution_space = typename Kokkos::DefaultExecutionSpace::execution_space;
    Kokkos::Experimental::UniqueToken<execution_space, Kokkos::Experimental::UniqueTokenScope::Global> tokens;

    Array<OutputType> value(position.size());

    parallel_for(position.size(), [=, &expression, &tokens](size_t i) {
      const int32_t t = tokens.acquire();

      auto& execution_policy = context_list[t];

      Adapter::convertArgs(execution_policy.currentContext(), position[i]);
      auto result = expression.execute(execution_policy);
      value[i]    = convert_result(std::move(result));

      tokens.release(t);
    });

    return value;
  }
};

#endif /* INTERPOLATE_ARRAY_HPP */
