#ifndef MESSENGER_HPP
#define MESSENGER_HPP

#include <PastisMacros.hpp>
#include <PastisAssert.hpp>

class Messenger
{
 private:
  static Messenger* m_instance;
  Messenger(int& argc, char* argv[]);

  int m_rank{0};
  int m_size{1};
 public:
  static void create(int& argc, char* argv[]);
  static void destroy();

  PASTIS_INLINE
  static Messenger& getInstance()
  {
    Assert(m_instance != nullptr);
    return *m_instance;
  }

  PASTIS_INLINE
  const int& rank() const
  {
    return m_rank;
  }

  PASTIS_INLINE
  const int& size() const
  {
    return m_size;
  }

  Messenger(const Messenger&) = delete;
  ~Messenger();
};

PASTIS_INLINE
const Messenger& messenger()
{
  return Messenger::getInstance();
}

[[deprecated("use better name")]]
PASTIS_INLINE
const int& commRank()
{
  return messenger().rank();
}

[[deprecated("use better name")]]
PASTIS_INLINE
const int& commSize()
{
  return messenger().size();
}


#endif // MESSENGER_HPP
