#ifndef CSR_GRAPH_HPP
#define CSR_GRAPH_HPP

#include <Array.hpp>

class CSRGraph
{
 private:
  Array<int> m_entries;
  Array<int> m_neighbors;

 public:
  const Array<int>& entries() const
  {
    return m_entries;
  }

  const Array<int>& neighbors() const
  {
    return m_neighbors;
  }

  CSRGraph& operator=(CSRGraph&&) = default;
  CSRGraph& operator=(const CSRGraph&) = default;

  CSRGraph(Array<int> entries,
           Array<int> neighbors)
      : m_entries(entries),
        m_neighbors(neighbors)
  {
    ;
  }

  CSRGraph() = default;
  CSRGraph(CSRGraph&&) = default;
  CSRGraph(const CSRGraph&) = default;
  ~CSRGraph() = default;
};

#endif // CSR_GRAPH_HPP
