#include <language/ast/ASTBacktrace.hpp>

#include <language/ast/ASTNode.hpp>

ASTBacktrace* ASTBacktrace::m_instance = nullptr;

ASTBacktrace::ASTBacktrace(const std::shared_ptr<TAO_PEGTL_NAMESPACE::file_input<>>& file_input)
  : m_file_input(file_input)
{}

std::string
ASTBacktrace::errorMessageAt(const std::string& message) const
{
  auto& stack = ASTBacktrace::getInstance().m_stack;
  std::ostringstream error_msg;

  auto p = stack[stack.size() - 1]->begin();
  error_msg << rang::style::bold << p.source << ':' << p.line << ':' << p.column << ": " << rang::style::reset
            << message << rang::fg::reset << '\n';

  if (m_file_input.use_count() > 0) {
    error_msg << m_file_input->line_at(p) << '\n'
              << std::string(p.column - 1, ' ') << rang::fgB::yellow << '^' << rang::fg::reset << '\n';
  }

  return error_msg.str();
}

SourceLocation
ASTBacktrace::sourceLocation() const
{
  auto& stack = ASTBacktrace::getInstance().m_stack;

  auto p = stack[stack.size() - 1]->begin();
  return SourceLocation(p.source, p.line, p.column);
}

void
ASTBacktrace::create()
{
  if (m_instance == nullptr) {
    m_instance = new ASTBacktrace();
  } else {
    throw UnexpectedError("ASTBackTrace was already created!");
  }
}

void
ASTBacktrace::create(const std::shared_ptr<TAO_PEGTL_NAMESPACE::file_input<>>& file_input)
{
  if (m_instance == nullptr) {
    m_instance = new ASTBacktrace(file_input);
  } else {
    throw UnexpectedError("ASTBackTrace was already created!");
  }
}

void
ASTBacktrace::destroy()
{
  delete m_instance;
  m_instance = nullptr;
}
